/**************************/
/** FUNCIONES UTILIDADES **/
/**************************/
ab03bUtils = {
	array : {},
	combo : {},
	feedback : {},
	form : {},
	navegacion : {},
	tabla : {
		sortType : {},
		formatter : {}
	},
	util : {},
	properties : {}
};

//Funcion que pinta el texto en el feedback por defecto (ERROR)
ab03bUtils.feedback.pintarFeedbackError = function (textoError, feedback) {
	var feedbackError = feedback && feedback.length? feedback : $("#feedback_general");
	var mensajeError = textoError && textoError != "" ? textoError : $.rup.i18n.app.mensajes.errorGenerico;
	// Mostrar feedback
	feedbackError.rup_feedback("set", mensajeError, "error");
};

//Funcion que pinta el texto en el feedback por defecto (OK, ERROR, ALERT)
ab03bUtils.feedback.pintarFeedback = function (texto, tipo, feedback) {
	var feedback = feedback && feedback.length? feedback : $("#feedback_general");
	var mensaje = texto && texto != "" ? texto : $.rup.i18n.app.mensajes.errorGenerico;
	// Mostrar feedback
	feedback.rup_feedback("set", mensaje, tipo);
};

//Bloquear pantalla mientras se esta realizando una operacion en segundo plano
//Permite asignarle propiedades
ab03bUtils.util.bloquearInterfaz = function(properties){
	
	var defaultProp = {
		baseZ: 999999,
		centerX: true, 
		css:{
			paddingTop: "1em",
			paddingBottom: "1em",
			color: "#ffffff",
			borderColor: "#222",
			background: "#444",
			fontSize : "1.6em",
			cursor:		'default'
		},
		overlayCSS: {
			backgroundColor: 	'#222222', 
			opacity:			0.3,
			cursor:		'default'
		}, 
		message : $.rup.i18n.app.mensajes.cargando
	};
	$.blockUI($.extend(true, defaultProp, properties));
};
//Desbloquear pantalla
ab03bUtils.util.desBloquearInterfaz = function(){
	try{
		$.unblockUI();
	}catch(e){
		$('.blockUI').remove();
	}
};

//Devuelve true si la tabla esta vacia, false en caso contrario
ab03bUtils.tabla.isEmptyGrid = function (grid) {
    return grid.rup_grid('getDataIDs').length == 0;
};

ab03bUtils.tabla.formatterNifUpperCase = function (cellval){
	var resultado = "";
	if(cellval != undefined && cellval != '') {
		resultado = cellval.toUpperCase();
	}
	return resultado;
};

//Funcion que devuelve si un  formulario con el validate de UDA es valido, si no es valido muestra el feedback
ab03bUtils.form.validate = function($form, $feedback) {
	var $feedback = $feedback && $feedback.length? $feedback : $form.validate().settings.feedback;
	// Cerrar feedback errores
	ab03bUtils.feedback.cerrarFeedbacks($feedback);
		
	if ($form.validate().checkForm()) {
		return true;
	} else {
		var erroresMap = $form.validate().errorMap;
		
		$form.validate().showErrors(erroresMap);
		
		// Ejemplo crear mapa de errores propio...
		// var erroresMap = new Object();
		// erroresMap.codUsuario = "Literal de error1";
		// erroresMap.nif = "Literal de error2";
		// erroresMap['Campo Propio'] = "Literal de error3";
		
		var mensajeError = ab03bUtils.feedback.formatearErroresHtmlFeedback(erroresMap, $form);
		//Mostrar feedback
		ab03bUtils.feedback.pintarFeedbackError(mensajeError, $feedback);
		return false;
	}
};

//Cerrar feedbacks por defecto
ab03bUtils.feedback.cerrarFeedbacks = function (feedback) {
	$("#feedback_general").rup_feedback("close");
	//Cerrar el feedback especfico si se informa
	if (feedback && feedback.length){
		feedback.rup_feedback("close");
	}
};

ab03bUtils.feedback.formatearErroresHtmlFeedback = function (erroresMap, form) {
	var errorText = $("<ul>").addClass("rup-maint_feedbackUL").prepend($.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"));

	$.each(erroresMap, function(key, value){
		var errorKey = getFieldName(form, key);
		var fieldError = getFieldErrorLabel(errorKey);
		var fieldErrorMsg = getFieldErrorMsg(value);
		
		fieldError.append(fieldErrorMsg);
		errorText.append(fieldError);
	});
	
	return errorText;
};

/*
 * Pinta mensajes json parametrizables
 * @param source Texto del mensaje
 * @param params Valores que se quieren sustituir en el mensaje (puede ser array, string o varios parametros)
 */
ab03bUtils.util.messageFormatter = function(source, params) {
	if (arguments.length > 2 && params.constructor != Array) {
		params = $.makeArray(arguments).slice(1);
	}
	if (params.constructor != Array) {
		params = [params];
	}
	$.each(params, function(i, n) {
		source = source.replace(new RegExp("\\{" + i + "\\}", "g"), n);
	});
	return source;
};

function waitDialog(mensaje){
	//$(document).ajaxStop($.unblockUI());
	
	var mensajeMostrar = "Cargando datos. Por favor, espere...";
	if ($(mensaje).text() != ""){
		mensajeMostrar = $(mensaje).text();
	}
	
	$.blockUI({ message: "<div class='ab03b_modalWait'><img src='" + $.rup.APP_STATICS + "/images/busy.gif' /> "+mensajeMostrar+" </div>" });
	$(".blockUI.blockOverlay").css("z-index",9000);
	$(".blockUI.blockOverlay").css("opacity",0.5);
	$(".blockUI.blockMsg.blockPage").css("z-index",9001);
	$(".blockUI.blockMsg.blockPage").css("opacity",1);
	/*setTimeout(function() {$.unblockUI();	}, 30000);*/
}

function closeWaitDialog(){
	$.unblockUI();
}

function acordeon(id){
   if ($("#"+id).attr("estado") == 'show'){
       $("#"+id).hide("slow");
       $("#"+id).attr("estado",'hide');
   }
   else{
       $("#"+id).show("slow");
       $("#"+id).attr("estado",'show');
   }
}

function acordeonDesplegar(id){
	 $("#"+id).show("slow");
    $("#"+id).attr("estado",'show');
}

function resetFiltro($form){
	var $self = this;
	// Se eliminan los estilos de errores de validacion
	if ($form.data("validator") != undefined){
		var errorClass = $form.data("validator").settings.errorClass;
		$("."+errorClass,$form).removeClass(errorClass);
	}
	// Se realiza el reset de los campos ordinarios
	jQuery("input[type!='button'][type!='checkbox'][type!='radio'][type!='hidden'], textarea", $form).val(""); 
	jQuery("input[type='checkbox']", $form).not("[name*='jqg_GRID_']", $form).not("[disabled='disabled']", $form).removeAttr("checked");
	// Se realiza el reset de los rup_combo
	jQuery.each($("select.rup_combo",$form), function(index,elem){
			jQuery(elem).rup_combo("reset");
	});
	//Vaciar los autocompletes
	$("[ruptype='autocomplete']", $form).each(function (index, element) {
		$(element).val("");
	});
	
	$form.resetForm();
	
	return $self;
}

//Funcion que pinta el texto en el feedback por defecto (ERROR)
function pintarFeedbackError(textoError, feedback) {
	var feedbackError = feedback && feedback.length? feedback : $("#feedback_general"); 
	var mensajeError = textoError && textoError != "" ? textoError : $.rup.i18n.app.mensajes.errorGenerico;
	// Mostrar feedback
	feedbackError.rup_feedback("set", mensajeError, "error");
};

//Para validar el dni/nie del solicitante
//jQuery.validator.addMethod("dninie", 
function validaNif(nif){
    var numero, let, letra;
    var expresion_regular_dni = /^[XYZ]?\d{5,8}[A-Z]$/;

    var dni = nif.toUpperCase();

    if(expresion_regular_dni.test(dni) === true){
        numero = dni.substr(0,dni.length-1);
        numero = numero.replace('X', 0);
        numero = numero.replace('Y', 1);
        numero = numero.replace('Z', 2);
        let = dni.substr(dni.length-1, 1);
        numero = numero % 23;
        letra = 'TRWAGMYFPDXBNJZSQVHLCKET';
        letra = letra.substring(numero, numero+1);
        if (letra != let) {
            return false;
        }else{
            return true;
        }
    }else{
        return false;
    }
}//,$.rup.i18nParse($.rup.i18n.app,"EL DNI ES UNA MIERDA"));

//jQuery.validator.addMethod("cif",
function validaCif(cif){ 
	var pares = 0;
    var impares = 0;
    var suma;
    var ultima;
    var unumero;
    var uletra = new Array("J", "A", "B", "C", "D", "E", "F", "G", "H", "I");
    var xxx;
    var regular = new RegExp(/^[ABCDEFGHJNPQRSUVW]\d{7}[0-9,A-J]$/g);
    var texto = cif.toUpperCase();
  
    ultima = texto.substr(8,1);

    for (var cont = 1 ; cont < 7 ; cont ++){
        xxx = (2 * parseInt(texto.substr(cont++,1))).toString() + "0";
        impares += parseInt(xxx.substr(0,1)) + parseInt(xxx.substr(1,1));
        pares += parseInt(texto.substr(cont,1));
    }
    xxx = (2 * parseInt(texto.substr(cont,1))).toString() + "0";
    impares += parseInt(xxx.substr(0,1)) + parseInt(xxx.substr(1,1));
     
    suma = (pares + impares).toString();
    unumero = parseInt(suma.substr(suma.length - 1, 1));
    unumero = (10 - unumero).toString();
    if(unumero == 10) unumero = 0;
     
    if (!regular.exec(texto) || ((ultima != unumero) && (ultima != uletra[unumero]))){
    	return false;
	}else{
		return true;
	}
}//,$.rup.i18nParse($.rup.i18n.app,"EL cif ES UNA MIERDA"));


function getFieldName(form, fieldName){
	if (form && form.length > 0) {
		var labelForName = $("[name='" + fieldName + "']", form).attr("id");
		//Se selecciona el primer label con ese for
		var labelElem = form.find("label[for='" + labelForName + "']:first");
		if (labelElem.length>0){
			return labelElem.text();
		} else {
			//Puede ser un combo
			var labelElem = form.find("label[for='" + labelForName + "-button" + "']:first");
			if (labelElem.length>0){
				return labelElem.text();
			}
		}
	}
	//Si no encuentra el label devuelve el propio fieldName
	return fieldName;
}

//Funcion que devuelve el errorLabel formateado para mostrar 
function getFieldErrorLabel(errorLabel){
	return $("<li>").append("<b>" + errorLabel + "</b>");
}

//Funcion que devuelve el mensaje de error formateado para mostrar
function getFieldErrorMsg(errorMsg){
	if ($.isArray(errorMsg)){
		// En caso de que el mensaje de error sea un array de mensajes, se debera de recorrer y concatenar
		var baseUl = $("<ul>");
		for (var i=0; i<errorMsg.length; i++){
			baseUl.append($("<li>").append(errorMsg[i]));
		}
		return baseUl;
	}else{
		return $("<ul>").append($("<li>").append(errorMsg));
	}
};